/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.base;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.JVMSystemConstants;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.IVWAdaptor;
import filenet.vw.integrator.base.VWComponentManager;
import filenet.vw.integrator.base.VWResources;
import filenet.vw.server.VWCallbackHandler;
import filenet.vw.server.VWCapsule;
import filenet.vw.server.VWLoginModule;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;

public class VWAdaptor
implements Runnable {
    protected String m_queueName = null;
    protected String component_descriptor = null;
    protected VWXMLWrapper component_descriptor_doc = null;
    protected boolean done = false;
    protected IVWAdaptor adaptor = null;
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator");
    protected long startTime = 0L;
    protected Object statsSyncObj = new Object();
    protected double callTime = 0.0;
    protected double callCount = 0.0;
    protected String m_className = "VWAdaptor:";
    protected String m_status = null;
    private static String g_ClientName = null;
    private String m_routerURL = null;
    protected int m_index = 1;
    protected String m_id = null;
    private final DateFormat df = DateFormat.getDateTimeInstance(1, 1);

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 19:05:08  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.39  $";
    }

    public static String getClientName() {
        if (g_ClientName == null) {
            try {
                g_ClientName = InetAddress.getLocalHost().getHostName() + "(" + InetAddress.getLocalHost().getHostAddress() + ") ";
            }
            catch (Exception e) {
                g_ClientName = "localhost ";
            }
        }
        return g_ClientName;
    }

    public VWAdaptor(VWQueue queue, String component_descriptor, int index) throws Exception {
        String m_method = "<init>";
        this.m_queueName = queue.toString();
        this.m_id = this.m_queueName + "[" + index + "]";
        this.m_className = this.m_className + this.m_id;
        this.m_index = index;
        logger.entering(this.m_className, "<init>");
        this.component_descriptor = component_descriptor;
        this.component_descriptor_doc = new VWXMLWrapper(component_descriptor);
        this.m_routerURL = queue.getServiceSession().getRouterURL();
        System.getProperties().setProperty("filenet.pe.cm.connectionPoint", this.m_routerURL);
        logger.exiting(this.m_className, "<init>");
    }

    public String getLocaleDateStringNow() {
        return this.df.format(new Date());
    }

    private static int get_max_polling_rate(int default_polling_rate) {
        int max_polling_rate = default_polling_rate;
        try {
            String s = JVMSystemConstants.GetPrivilegedSystemProperty("filenet.pe.cm.max.polling.interval");
            if (s != null) {
                max_polling_rate = Integer.parseInt(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return max_polling_rate;
    }

    private static int get_polling_increment() {
        int polling_increment = 15000;
        try {
            String s = System.getProperty("filenet.pe.cm.polling.increment");
            if (s != null) {
                polling_increment = Integer.parseInt(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return polling_increment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String m_method = "run";
        logger.entering(this.m_className, m_method);
        try {
            String adaptor_class_name;
            this.done = false;
            this.startTime = System.currentTimeMillis();
            this.callTime = 0.0;
            this.callCount = 0.0;
            this.m_status = VWResources.VWS_ADAPTOR_RUN_STARTING.toString(this.m_id, this.getLocaleDateStringNow());
            HashMap queues = new HashMap();
            if (this.component_descriptor_doc == null) {
                throw new VWException("vw.integrator.base.NoComponentDescriptor", "Unable to obtain valid component descriptor for {0}.", this.m_id);
            }
            String context = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "jaas_configcontext");
            String username = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "jaas_username");
            String password = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "jaas_password");
            LoginContext lc = new LoginContext(context, new VWCallbackHandler(username, password));
            this.m_status = VWResources.VWS_ADAPTOR_RUN_PERFORMJAASLOGIN.toString(new Object[]{this.m_id, context, username, this.getLocaleDateStringNow()});
            lc.login();
            VWSession session = VWLoginModule.getSession(lc);
            if (session == null) {
                throw new VWException("vw.integrator.base.NoValidSession", "Unable to obtain valid session object for {0}.", username);
            }
            String realPW = null;
            VWCapsule capsule = new VWCapsule();
            capsule.setString(password);
            realPW = capsule.getString();
            String maskPw = VWComponentManager.maskPW(realPW);
            VWQueue queue = session.getQueue(this.m_queueName);
            queue.setBufferSize(1);
            VWQueueDefinition qdef = queue.fetchQueueDefinition();
            if (!session.isMemberOfGroup("SysAdminG")) {
                String[] readusers;
                String[] writeusers = qdef.getWriteSecurity();
                if (writeusers != null && writeusers.length > 0) {
                    boolean found = false;
                    boolean[] isgroup = session.fetchIsGroup(writeusers);
                    for (int i = 0; i < isgroup.length && !found; ++i) {
                        if (isgroup[i]) {
                            found = session.isMemberOfGroup(writeusers[i]);
                            continue;
                        }
                        if (!username.equals(writeusers[i])) continue;
                        found = true;
                    }
                    if (!found) {
                        VWException ex = new VWException("VWAdaptorControl.UserLacksWritePrivileges", "User {0} does not have write privileges to queue {1}.  Verify users privileges via the System Configuration application.", username, qdef.getName());
                        logger.throwing(this.m_className, m_method, ex);
                        throw ex;
                    }
                }
                if ((readusers = qdef.getReadSecurity()) != null && readusers.length > 0) {
                    boolean found = false;
                    boolean[] isgroup = session.fetchIsGroup(readusers);
                    for (int i = 0; i < isgroup.length && !found; ++i) {
                        if (isgroup[i]) {
                            found = session.isMemberOfGroup(readusers[i]);
                            continue;
                        }
                        if (!username.equals(readusers[i])) continue;
                        found = true;
                    }
                    if (!found) {
                        VWException vwex = new VWException("VWAdaptorControl.UserLacksReadPrivileges", "User {0} does not have read privileges to queue {1}.  Verify users privileges via the System Configuration application.", username, qdef.getName());
                        logger.throwing(this.m_className, m_method, vwex);
                        throw vwex;
                    }
                }
            }
            String pr = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "polling_rate");
            int polling_rate = 0;
            if (pr != null) {
                polling_rate = Integer.parseInt(pr);
            }
            int initial_polling_rate = polling_rate;
            int max_polling_rate = VWAdaptor.get_max_polling_rate(polling_rate);
            int polling_increment = VWAdaptor.get_polling_increment();
            String exception_submap = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "exception_submap");
            if (exception_submap == null || exception_submap.length() == 0) {
                exception_submap = "Malfunction";
            }
            if ((adaptor_class_name = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "adaptor_class")) == null) {
                throw new VWException("vw.integrator.base.AdaptorClassNotDefined", "Adaptor class not specified in component descriptor.");
            }
            Class<?> adaptor_class = Class.forName(adaptor_class_name);
            if (adaptor_class == null) {
                throw new VWException("vw.integrator.base.CantLoadAdaptorClass", "Unable to load adaptor class: {0}.", adaptor_class_name);
            }
            this.adaptor = (IVWAdaptor)adaptor_class.newInstance();
            if (this.adaptor == null) {
                throw new VWException("vw.integrator.base.CantCreateAdaptorInstance", "Unable to create instance of adaptor: {0}.", adaptor_class_name);
            }
            AdaptorInitAction init_action = new AdaptorInitAction(this.adaptor, this.component_descriptor);
            try {
                Subject.doAsPrivileged(lc.getSubject(), init_action, null);
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
            VWQueueQuery queue_query = null;
            boolean needToRecoverVWSession = false;
            String needToRecoverVWSessionReason = null;
            int exception_polling_interval = 15000;
            try {
                String s = System.getProperty("filenet.PE.exception.polling.interval.ms");
                if (s == null) {
                    s = System.getProperty("filenet.pe.cm.exception.polling.interval");
                }
                if (s != null) {
                    exception_polling_interval = Integer.parseInt(s);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (logger.isFinest()) {
                logger.finest(this.m_className, m_method, "Exception Polling Interval=" + exception_polling_interval);
            }
            while (!this.done) {
                try {
                    if (needToRecoverVWSession) {
                        VWAdaptor e = this;
                        synchronized (e) {
                            this.wait(exception_polling_interval);
                        }
                        this.m_status = VWResources.VWS_ADAPTOR_RUN_NEEDTORECOVERSESSION.toString(this.m_id);
                        queue_query = null;
                        queue = null;
                        session = null;
                        logger.info(this.m_className, m_method, "Attempt to recover VWSession (" + this.m_id + "), " + username + ", " + maskPw + ", " + this.m_routerURL + " ,reason=" + needToRecoverVWSessionReason);
                        session = new VWSession(username, realPW, this.m_routerURL);
                        queue = session.getQueue(this.m_queueName);
                        queue.setBufferSize(1);
                        needToRecoverVWSession = false;
                    }
                    this.m_status = VWResources.VWS_ADAPTOR_RUN_STARTED.toString(this.m_id, this.getLocaleDateStringNow());
                    boolean more_items_to_query = true;
                    block34: while (more_items_to_query && !this.done) {
                        block67: {
                            try {
                                queue_query = queue.createQuery(null, null, null, 16, null, null, 5);
                                if (queue_query != null && queue_query.hasNext()) break block67;
                                more_items_to_query = false;
                                polling_rate = Math.min(max_polling_rate, polling_rate + polling_increment);
                                break;
                            }
                            catch (VWException vwex) {
                                String s = VWException.DescribeThrowableAndItsCauseWithStackFrames(vwex, 20);
                                logger.info(this.m_className, m_method, "query got VWException=" + s);
                                if (vwex.getLocalizedMessage().indexOf("21000012") >= 0) {
                                    this.done = true;
                                }
                                throw vwex;
                            }
                            catch (Exception e) {
                                needToRecoverVWSessionReason = VWException.DescribeThrowableAndItsCauseWithStackFrames(e, 20);
                                logger.severe(this.m_className, m_method, "query got Exception=" + needToRecoverVWSessionReason);
                                needToRecoverVWSession = true;
                                break;
                            }
                        }
                        while (queue_query.hasNext()) {
                            String signature;
                            HashMap<String, String> signatures;
                            polling_rate = initial_polling_rate;
                            VWStepElement se = (VWStepElement)queue_query.next();
                            String wobId = se.getWorkObjectNumber();
                            String workflowName = se.getWorkflowName();
                            if (logger.isFinest()) {
                                logger.finest(this.m_className, m_method, "execute step element...");
                            }
                            if ((signatures = (HashMap<String, String>)queues.get(this.m_queueName)) == null) {
                                signatures = new HashMap<String, String>();
                                queues.put(this.m_queueName, signatures);
                            }
                            String opname = se.getOperationName();
                            if (logger.isFinest()) {
                                logger.finest(this.m_className, m_method, "operation name:  " + opname);
                            }
                            if ((signature = (String)signatures.get(opname)) == null) {
                                VWAttributeInfo ai;
                                VWOperationDefinition opdef = null;
                                try {
                                    opdef = qdef.getOperation(opname);
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                if (opdef != null && (ai = opdef.getAttributeInfo()) != null) {
                                    String operation_descriptor = (String)ai.getFieldValue("F_OperationDescriptor");
                                    VWXMLWrapper operation_descriptor_doc = new VWXMLWrapper(operation_descriptor);
                                    signature = VWXMLWrapper.getNodeValue(operation_descriptor_doc.getRootNode(), "signature");
                                    signatures.put(opname, signature);
                                }
                            }
                            try {
                                long tempCallTime = System.currentTimeMillis();
                                this.m_status = VWResources.VWS_ADAPTOR_RUN_PROCESSINGSTEPELEMENT.toString(new Object[]{this.m_id, wobId, workflowName, signature, this.getLocaleDateStringNow()});
                                AdaptorAction action = new AdaptorAction(this.adaptor, se, signature);
                                Object result = null;
                                try {
                                    Subject.doAsPrivileged(lc.getSubject(), action, null);
                                }
                                catch (PrivilegedActionException pae) {
                                    throw pae.getException();
                                }
                                Object pae = this.statsSyncObj;
                                synchronized (pae) {
                                    this.callTime += (double)(System.currentTimeMillis() - tempCallTime);
                                    this.callCount += 1.0;
                                }
                                try {
                                    se.doDispatch();
                                    this.m_status = VWResources.VWS_ADAPTOR_RUN_DISPATCHEDSTEPELEMENTOK.toString(new Object[]{this.m_id, wobId, workflowName, signature, this.getLocaleDateStringNow()});
                                    logger.info(this.m_className, m_method, this.m_status);
                                    continue;
                                }
                                catch (VWException ex) {
                                    if (ex.getLocalizedMessage().indexOf("d56d000c") >= 0) {
                                        VWParameter[] se_params = se.getParameters(767, 1);
                                        String resultName = se_params[se_params.length - 1].getName();
                                        Object resultValue = se.getParameterValue(resultName);
                                        se.doLock(true);
                                        se.setParameterValue(resultName, resultValue, true);
                                        se.doDispatch();
                                        continue;
                                    }
                                    String cause = " !!! FAILED in dispatching !!! due to " + VWException.DescribeThrowableAndItsCause(ex);
                                    needToRecoverVWSessionReason = this.m_status = this.m_status + cause;
                                    logger.severe(this.m_className, m_method, this.m_status);
                                    needToRecoverVWSession = true;
                                }
                            }
                            catch (Throwable t) {
                                logger.throwing(this.m_className, m_method, t);
                                try {
                                    if (t instanceof InvocationTargetException) {
                                        t = ((InvocationTargetException)t).getTargetException();
                                    }
                                    String cause = VWException.DescribeThrowableAndItsCause(t);
                                    se.setException(exception_submap, VWAdaptor.getClientName() + cause);
                                    this.m_status = VWResources.VWS_ADAPTOR_RUN_DISPATCHSETOEXCEPTIONMAP.toString(new Object[]{this.m_id, wobId, workflowName, signature, exception_submap, cause, this.getLocaleDateStringNow()});
                                    logger.info(this.m_className, m_method, this.m_status);
                                    se.doDispatch();
                                    continue;
                                }
                                catch (Throwable t2) {
                                    String cause = " !!! FAILED in dispatching to Exception map !!! due to " + VWException.DescribeThrowableAndItsCause(t2);
                                    needToRecoverVWSessionReason = this.m_status = this.m_status + cause;
                                    logger.severe(this.m_className, m_method, this.m_status);
                                    needToRecoverVWSession = true;
                                }
                            }
                            continue block34;
                        }
                    }
                }
                catch (VWException vwex) {
                    String cause = " !!! FAILED !!! due to " + VWException.DescribeThrowableAndItsCause(vwex);
                    this.m_status = this.m_status + cause;
                    logger.severe(this.m_className, m_method, this.m_status);
                    if (vwex.getLocalizedMessage().indexOf("21000012") >= 0) {
                        logger.throwing("filenet.vw.integrator.base.VWAdaptor", "run", vwex);
                        this.done = true;
                        throw vwex;
                    }
                    needToRecoverVWSessionReason = this.m_status;
                    needToRecoverVWSession = true;
                }
                catch (Throwable t) {
                    logger.throwing("filenet.vw.integrator.base.VWAdaptor", "run", t);
                    throw t;
                }
                if (this.done) continue;
                this.m_status = VWResources.VWS_ADAPTOR_RUN_WAITING.toString(new Object[]{this.m_id, new Long(polling_rate), this.getLocaleDateStringNow()});
                VWAdaptor t = this;
                synchronized (t) {
                    this.wait(polling_rate);
                }
            }
            if (queue_query != null) {
                while (queue_query.hasNext()) {
                    VWStepElement se = (VWStepElement)queue_query.next();
                    se.doAbort();
                }
            }
            this.adaptor.stop();
            this.m_status = VWResources.VWS_ADAPTOR_RUN_STOPPED.toString(this.m_id, this.getLocaleDateStringNow());
            if (session != null) {
                session.logoff();
            }
            if (logger.isFinest()) {
                logger.finer(this.m_className, m_method, Thread.currentThread() + " - has shut down.");
            }
        }
        catch (Throwable t) {
            String s;
            String cause = VWException.DescribeThrowableAndItsCause(t);
            this.m_status = s = VWResources.VWS_ADAPTOR_RUN_STOPPED_WITH_EX.toString(new Object[]{this.m_id, cause, this.m_status});
            logger.severe(this.m_className, m_method, this.m_status);
            logger.throwing(this.m_className, m_method, t);
        }
        this.done = true;
        logger.exiting(this.m_className, m_method);
    }

    public void stop() {
        String m_method = "stop";
        logger.entering(this.m_className, "stop");
        try {
            if (this.adaptor != null) {
                this.adaptor.stop();
            }
        }
        catch (Exception ex) {
            logger.info(this.m_className, "stop", ex);
        }
        this.done = true;
        logger.exiting(this.m_className, "stop");
    }

    public synchronized long getAverageCallsPerMinute() throws Exception {
        long elapsedTimeInMinutes = (System.currentTimeMillis() - this.startTime) / 60000L;
        if (elapsedTimeInMinutes == 0L) {
            return (long)this.callCount;
        }
        return (long)(this.callCount / (double)elapsedTimeInMinutes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAverageCallTimeMillis() throws Exception {
        Object object = this.statsSyncObj;
        synchronized (object) {
            if (this.callCount == 0.0) {
                return 0L;
            }
            return (long)(this.callTime / this.callCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetCallTimeStatistics() throws Exception {
        Object object = this.statsSyncObj;
        synchronized (object) {
            this.startTime = System.currentTimeMillis();
            this.callTime = 0.0;
            this.callCount = 0.0;
        }
    }

    public boolean isRunning() {
        return !this.done;
    }

    public String toString() {
        if (this.m_status != null) {
            return this.m_status + ". " + this.callCount + " RPCs (" + this.callTime + "ms).";
        }
        return this.m_className;
    }

    class AdaptorInitAction
    implements PrivilegedExceptionAction {
        protected IVWAdaptor adaptor = null;
        protected String descriptor = null;

        public AdaptorInitAction(IVWAdaptor adaptor, String descriptor) {
            this.adaptor = adaptor;
            this.descriptor = descriptor;
        }

        public Object run() throws Exception {
            this.adaptor.init(this.descriptor);
            return null;
        }
    }

    class AdaptorAction
    implements PrivilegedExceptionAction {
        protected IVWAdaptor adaptor = null;
        protected VWStepElement se = null;
        protected String signature = null;

        public AdaptorAction(IVWAdaptor adaptor, VWStepElement se, String signature) {
            this.adaptor = adaptor;
            this.se = se;
            this.signature = signature;
        }

        public Object run() throws Exception {
            this.adaptor.execute(this.se, this.signature);
            return null;
        }
    }
}

